 aR  w Q mP9      h	 oP       nSystem-wide
/* This module contains the PLM interface to the */
/* RTD version of many of the MsDOS calls.       */

/* Error codes */

DCL eMsOK              LIT '0';
DCL eMsInvalidParm     LIT '1';
DCL eMsFileNotFound    LIT '2';
DCL eMsPathNotFound    LIT '3';
DCL eMsTooManyOpen     LIT '4';
DCL eMsAccessDenied    LIT '5';
DCL eMsInvalidConn     LIT '6';
DCL eMsMemoryTrashed   LIT '7';
DCL eMsOutOfMemory     LIT '8';
DCL eMsInvalidBlock    LIT '9';
DCL eMsBadEnvironment  LIT '10';
DCL eMsBadFormat       LIT '11';
DCL eMsInvalidAccess   LIT '12';
DCL eMsInvalidData     LIT '13';

DCL eMsInvalidDrive    LIT '15';
DCL eMsDirectoryInUse  LIT '16';
DCL eMsNotSameDevice   LIT '17';
DCL eMsNoMoreFiles     LIT '18';


/* Machine types */

DCL cpMachine          LIT '0';
DCL pcMachine          LIT '1';


/* Attach Modes */

DCL attachOldMode      LIT '1';
DCL attachUpdateMode   LIT '2';
DCL attachNewMode      LIT '3';

/* Attach accesses */

DCL attachReadAccess   LIT '0';
DCL attachWriteAccess  LIT '1';
DCL attachUpdateAccess LIT '2';

/* Attach attributes */

DCL normalFile         LIT '00H';
DCL readOnlyFile       LIT '01H';
DCL hiddenFile         LIT '02H';
DCL systemFile         LIT '04H';
DCL volumeLabelFile    LIT '08H';
DCL directoryFile      LIT '10H';
DCL archiveBit         LIT '20H';


/* Seek Modes */

DCL seekBegPlus        LIT '0';
DCL seekCurPlus        LIT '1';
DCL seekEndPlus        LIT '2';


/* FCB Read Modes */

DCL readSeq            LIT '0';
DCL readRnd            LIT '1';
DCL readRndBlk         LIT '2';


/* FCB Write Modes */

DCL writeSeq           LIT '0';
DCL writeRnd           LIT '1';
DCL writeRndBlk        LIT '2';
$EJECT

/* Structures */

DCL LineInType         LIT 'STRUCTURE
(maxChars      BYTE,
 actualChars   BYTE,
 chars (1)     BYTE)';

DCL ParamBlockType 	   LIT 'STRUCTURE
 (sEnvironment	SELECTOR,
		pCommandLine	PTR,
  pFcb1        PTR,
  pFcb2        PTR)';

DCL PdbType            LIT 'STRUCTURE
 (PdbTypePt1,
  PdbTypePt2)';

DCL PdbTypePt1         LIT
 'exitInt      WORD,
  endBlock     WORD,
  rsrvd1       BYTE,
  cpmJnk (5)   BYTE,
  exitAddr     PTR,
  ctlCAddr     PTR,
  abortAddr    PTR,
  parent       SELECTOR,
  files (20)   BYTE';

DCL PdbTypePt2         LIT
 'sEnvironment SELECTOR,
  saveUserStk  PTR,
  rsrvd2 (31)  BYTE,
  callSys (5)  BYTE,
  rsrvd3 (6)   BYTE,
  fcb1 (16)    BYTE,
  fcb2 (20)    BYTE,
  cmdLineLen   BYTE,
  cmdLineChars (1) BYTE';



/* File Control Block */

DCL FcbType            LIT 'STRUCTURE
(BasicFcbPart)';

DCL ExtendedFcbType    LIT 'STRUCTURE
(flag          BYTE,
 reserved1 (5) BYTE,
 attribute     BYTE,
 BasicFcbPart)';

DCL BasicFcbPart       LIT
'driveNumber   BYTE,
 fileName (8)  BYTE,
 extension (3) BYTE,
 currentBlock  WORD,
 recordSize    WORD,
 fileSize      DWORD,
 lastModDate   WORD,
 lastModTime   WORD,
 reserved2 (8) BYTE,
 currentRecd   BYTE,
 relativeRecd  DWORD';

DCL ofBit              LIT '0800h';
DCL dfBit              LIT '0400h';
DCL ifBit              LIT '0200h';
DCL tfBit              LIT '0100h';
DCL sfBit              LIT '0080h';
DCL zfBit              LIT '0040h';
DCL afBit              LIT '0010h';
DCL pfBit              LIT '0004h';
DCL cfBit              LIT '0001h';

DCL RegistersType      LIT 'STRUCTURE
(es            WORD,
 ds            WORD,
 bp            WORD,
 di            WORD,
 si            WORD,
 dx            WORD,
 cx            WORD,
 bx            WORD,
 ax            WORD,
 flags         WORD)';
$EJECT

/* Input / Output */


/* NOTE: Format of strings for LineOut and  */
/* PrintLine is characters ending with '$'. */
/* The '$' character is not printed.        */
/* LineIn structure is described above.     */


MsKeyPressed: PROCEDURE BOOLEAN EXTERNAL;
  END;

MsCharIn: PROCEDURE BYTE EXTERNAL;
  END;

MsCharOut: PROCEDURE (char) EXTERNAL;
  DCL char       BYTE;
  END;

MsPrintChar: PROCEDURE (char) EXTERNAL;
  DCL char       BYTE;
  END;

MsLineIn: PROCEDURE (pLineIn) EXTERNAL;
  DCL pLineIn    PTR;
  END;

MsLineOut: PROCEDURE (pLine) EXTERNAL;
  DCL pLine      PTR;
  END;

MsPrintLine: PROCEDURE (pLine) EXTERNAL;
  DCL pLine      PTR;
  END;
$EJECT

/* Xenix-like File Calls */


/* NOTE: Format of strings for file system  */
/* calls is ascii characters ending with 0. */
/* THIS IS DIFFERENT FROM I/O ROUTINES.     */

/* pError =>  Error,  a WORD value.  */

/* NOTE: attribute is added; password removed */

MsAttach: PROCEDURE (pPathName, mode, access, attribute, pError) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL access     BYTE;
  DCL attribute  WORD;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsRead: PROCEDURE (conn, pBuffer, count, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;

/* NOTE: MsDos returns amount written */

MsWrite: PROCEDURE (conn, pBuffer, count, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;

MsSeek: PROCEDURE (conn, mode, count, pError) DWORD EXTERNAL;
  DCL mode       BYTE;
  DCL conn       WORD;
  DCL count      DWORD;
  DCL pError     PTR;
  END;

MsRename: PROCEDURE (pOldName, pNewName, pError) EXTERNAL;
  DCL pOldName   PTR;
  DCL pNewName   PTR;
  DCL pError     PTR;
  END;

MsDelete: PROCEDURE (pPathname, pError) EXTERNAL;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsDetach: PROCEDURE (conn, pError) EXTERNAL;
  DCL conn       WORD;
  DCL pError     PTR;
  END;
$EJECT

/* Xenix-like Directory Calls */

MsAddDirectory: PROCEDURE (pDirName, pError) EXTERNAL;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsDeleteDirectory: PROCEDURE (pDirName, pError) EXTERNAL;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsSetCurrentDirectory: PROCEDURE (pDirName, pError) EXTERNAL;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsGetCurrentDirectory: PROCEDURE (drive, pDirName, pError) EXTERNAL;
  DCL drive      BYTE;
  DCL pDirName   PTR;
  DCL pError     PTR;
  END;

MsFindFirstDirEntry: PROCEDURE (pPathname, attr, pError) EXTERNAL;
  DCL attr       WORD;
  DCL pPathName  PTR;
  DCL pError     PTR;
  END;

MsFindNextDirEntry: PROCEDURE (pError) EXTERNAL;
  DCL pError     PTR;
  END;


/* Xenix-like Misc Calls */


MsDuplicateFileConn: PROCEDURE (conn, newConn, pError) WORD EXTERNAL;
  DCL conn       WORD;
  DCL newConn    WORD;
  DCL pError     PTR;
  END;

MsChangeAttributes: PROCEDURE (pPathname, attr, mode, pError) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL attr       WORD;
  DCL pPathname  PTR;
  DCL pError     PTR;
  END;

MsIOControl: PROCEDURE (conn, pBuffer, count, mode, pError) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL conn       WORD;
  DCL count      WORD;
  DCL pBuffer    PTR;
  DCL pError     PTR;
  END;
$EJECT

/* FCB File Calls */

/* pStatus => Status, a BYTE value.  */

MsFCBAttach: PROCEDURE (pFCB, mode, pStatus) EXTERNAL;
  DCL mode       BYTE;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBRead: PROCEDURE (pFCB, mode, count, pStatus) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL count      WORD;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBWrite: PROCEDURE (pFCB, mode, count, pStatus) WORD EXTERNAL;
  DCL mode       BYTE;
  DCL count      WORD;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBRename: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBDelete: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBDetach: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBFirstEntry: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBNextEntry: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBFileSize: PROCEDURE (pFCB, pStatus) EXTERNAL;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;

MsFCBSetRelativeRecord: PROCEDURE (pFCB) EXTERNAL;
  DCL pFCB       PTR;
  END;

MsFCBParseFileName: PROCEDURE (controls, pString, pFCB, pStatus) PTR EXTERNAL;
  DCL controls   BYTE;
  DCL pString    PTR;
  DCL pFCB       PTR;
  DCL pStatus    PTR;
  END;
$EJECT

/* Disk Calls */

MsFlushAllDisks: PROCEDURE EXTERNAL;
  END;

/* Returns the number of logical drives */

MsSetCurrentDisk: PROCEDURE (drive) BYTE EXTERNAL;
  DCL drive      BYTE;
  END;

MsGetCurrentDisk: PROCEDURE BYTE EXTERNAL;
  END;

MsSetDiskXferAddr: PROCEDURE (pAddr) EXTERNAL;
  DCL pAddr      PTR;
  END;

MsGetDiskXferAddr: PROCEDURE PTR EXTERNAL;
  END;

MsGetDiskFreeSpace: PROCEDURE (drive, pInfo) EXTERNAL;
  DCL drive      BYTE;
  DCL pInfo      PTR;
  END;

MsDeviceListPtr: PROCEDURE PTR EXTERNAL;
  END;
$EJECT

/* Memory Calls */

/* Error is a WORD value */

MsAllocate: PROCEDURE (numBlks, pError) PTR EXTERNAL;
  DCL numBlks    WORD;
  DCL pError     PTR;
  END;

MsFree: PROCEDURE (pBlock, pError) EXTERNAL;
  DCL pBlock     PTR;
  DCL pError     PTR;
  END;


/* Process */

/* CCOS exitCode is WORD; MsDos exitcode is BYTE */

MsCreateProcess: PROCEDURE (pCommandLine, pParmBlock, pError) EXTERNAL;
  DCL pCommandLine  PTR;
  DCL pParmBlock    PTR;
  DCL pError        PTR;
  END;

MsGetExitCode: PROCEDURE WORD EXTERNAL;
  END;

MsExit: PROCEDURE (exitCode) EXTERNAL;
  DCL exitCode   BYTE;
  END;


/* System related */

MsInMsDosPtr: PROCEDURE PTR EXTERNAL;
  END;

MsCallDriver: PROCEDURE (pDeviceHeader, pRequestBlock) EXTERNAL;
  DCL pDeviceHeader   PTR;
  DCL pRequestBlock   PTR;
  END;

MsGetEntrypoint: PROCEDURE (pSignature, pError) PTR EXTERNAL;
  DCL pSignature PTR;
  DCL pError     PTR;
  END;

MsSetCntlCInterrupt: PROCEDURE (cntlCRtnOffset) EXTERNAL;
  DCL cntlCRtnOffset  PTR;
  END;

MsGetMachineType: PROCEDURE BYTE EXTERNAL;
  END;

MsTurnCursorOn: PROCEDURE EXTERNAL;
  END;

MsTurnCursorOff: PROCEDURE EXTERNAL;
  END;
